import * as server from "@minecraft/server";
import * as ui from "@minecraft/server-ui";

// import * as l_blocks from './list/blocks.js';
import * as l_evidence from './list/evidence.js';
import * as l_mobs from './list/mobs.js';
import * as l_players from './list/players.js';

import * as setting from "./func/setting.js"
import * as action from "./func/action.js"
import * as hint from "./func/hint.js"

// ********************************* //
// event
// ********************************* //

//interact検知
server.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    initEvent.blockComponentRegistry.registerCustomComponent("mob:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            //mobs
            const mob_data = l_mobs.search_mobs(block.type.id);
            //players
            const player_data = l_players.search_players(player.name);
            if (mob_data && player_data) {
                l_mobs.update_mobs_ms(mob_data, player_data);
                if (player_data.on_talk) {
                    // player.inputPermissions.cameraEnabled = false;
                    player.inputPermissions.movementEnabled = false;
                    player.onScreenDisplay.setActionBar(l_mobs.search_mobs_ms(player_data));
                    player.playSound("mob.villager.yes");
                } else {
                    player.inputPermissions.cameraEnabled = true;
                    player.inputPermissions.movementEnabled = true;
                    player.onScreenDisplay.setActionBar("（会話終了）");
                    player.playSound("sound.run");
                }
            }
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("search:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            const x_y_z = String(block.location.x) + " " + String(block.location.y) + " " + String(block.location.z);
            //evidence
            const block_data = l_evidence.search_evidence(x_y_z);
            if (block_data) {
                player.onScreenDisplay.setActionBar(l_evidence.search_evidence_ms(x_y_z));
                player.playSound("random.pop");
            }
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("furniture:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            // player.onScreenDisplay.setActionBar("一般的な家具や家電だ");
            // player.playSound("random.pop");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("statue:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;

            player.playSound("sound.run")
            //form
            const form = new ui.ModalFormData();
            form.title("ドルナド像を見つけた");
            form.textField("逮捕する人物の名前は何？", "カタカナ");
            form.submitButton("逮捕する");
            form.show(player).then(response => {
                if (response.canceled) {
                    return;
                }
                const mob_data = l_mobs.survey_mobs(String(response.formValues[0]));

                if (mob_data) {
                    player.runCommandAsync("fill 12 2 29 12 3 29 air");
                    player.runCommandAsync("setblock 41 -17 45 block:mob_1f");
                    player.runCommandAsync("setblock 41 -16 45 " + mob_data.id);
                    if (mob_data.name == "ガブリ") {
                        player.runCommandAsync("scoreboard players set end_b b 1");
                    }
                    player.runCommandAsync("function statue/statue");
                    player.playSound("sound.run");

                    //発言解除
                    for (const player of server.world.getAllPlayers()) {
                        const player_data = l_players.search_players(player.name);
                        if (!player_data) continue;
                        player_data.on_talk = false;
                    }
                } else {
                    player.onScreenDisplay.setActionBar("その名前の怪しい人物はいません。");

                }
            }).catch(error => {
                return;
            });
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("survey:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.playSound("random.pop");
            //form
            const form = new ui.ModalFormData();
            form.title("鑑識課のカンシキ");
            form.textField("調べたい人物の名前", "カタカナ");
            form.submitButton("連れてきてもらう");
            form.show(player).then(response => {
                if (response.canceled) {
                    return;
                }
                const mob_data = l_mobs.survey_mobs(String(response.formValues[0]));

                if (mob_data) {
                    // player.runCommandAsync("tp @s 41 2 47 facing 40 2 47");
                    player.teleport({ x: 41.5, y: 2, z: 42.5 }, { facingLocation: { x: 41.5, y: 2, z: 43.5 }, });
                    player.playSound("random.orb");
                    player.runCommandAsync("setblock 41 2 45 block:mob_1f");
                    player.runCommandAsync("setblock 41 3 45 " + mob_data.id);
                    player.onScreenDisplay.setActionBar(mob_data.name + "を連れてきた");
                } else {
                    player.onScreenDisplay.setActionBar("その名前の怪しい人物はいませんでした");

                }
            }).catch(error => {
                return;
            });
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("hint:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.playSound("random.pop");
            hint.hint_ModalForm(player);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("pass:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.playSound("random.pop");
            action.pass_ModalForm(player, block);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("drink:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            action.drink(player, block);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("food:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            action.food(player, block);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("potato:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.playSound("sound.potato");
            // action.potato(player, block);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("alb:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            action.alb(player, block);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("burger:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            action.burger(player, block);
        }
    });

});

// ********************************* //
// system
// ********************************* //

//5秒ループ
server.system.runInterval(() => {
    for (const player of server.world.getAllPlayers()) {
        const player_data = l_players.search_players(player.name);
        if (!player_data) continue;
        //mobトーク
        if (player_data.on_talk) player.onScreenDisplay.setActionBar(l_mobs.search_mobs_ms(player_data));
    }
}, 100)
//初期スポン
server.world.afterEvents.playerSpawn.subscribe(event => {
    const player = event.player;

    //名前登録
    if (!l_players.search_players(player.name)) {
        l_players.game_players.push({
            "name": player.name,
            "on_talk": false,
            "on_mob_id": null,
            "on_mob_ms_index": 0
        })
    }
    // 音楽再生

    // server.world.queueMusic("sound.bgm", {
    server.world.playMusic("sound.bgm", {
        fade: 0.0,
        loop: true,
        volume: 1.0,
    });
    player.runCommandAsync("function z/set/hud");
    player.inputPermissions.cameraEnabled = true;
    player.inputPermissions.movementEnabled = true;


    // player.playSound("sound.talk", {
    //     location: {
    //         x: player.location.x,
    //         y: player.location.y,
    //         z: player.location.z
    //     },
    //     pitch: 2.0,
    //     volume: 1,
    // })
});