import * as server from "@minecraft/server";

// 共通
export function set_obj(obj_id, obj_name) {
    let objective = server.world.scoreboard.getObjective(obj_id);

    if (!objective) {
        objective = server.world.scoreboard.addObjective(obj_id, obj_name);
    }
}

export function set_score(obj_id, score_id, score) {
    let objective = server.world.scoreboard.getObjective(obj_id);
    const score_Identity = score_id.scoreboardIdentity;
    objective.setScore(score_Identity, score);
}

export function get_score(obj_id, score_id) {
    let objective = server.world.scoreboard.getObjective(obj_id);
    const score_Identity = score_id.scoreboardIdentity;
    if (score_Identity === undefined) {
        return -1;
    }
    return objective.getScore(score_Identity) ?? 0;
}

export function set_Sidebar(obj_id) {
    let objective = server.world.scoreboard.getObjective(obj_id);
    server.world.scoreboard.setObjectiveAtDisplaySlot(DisplaySlotId.Sidebar, {
        objective: objective,
        sortOrder: ObjectiveSortOrder.Descending,
    });
}
