import * as server from "@minecraft/server";
import * as ui from "@minecraft/server-ui";

export function hint_ModalForm(player) {
    const form = new ui.ModalFormData();
    form.title("謎解きのヒントと答え");
    form.dropdown("謎解き", q_list);
    form.dropdown("上で選択した謎の", ["ヒント1を聞く", "ヒント2を聞く", "答えを聞く"]);
    form.submitButton("ここを押すと表示されます")
    form.show(player).then((response) => {
        switch (response.formValues[1]) {
            case 0:
                server.world.sendMessage("ヒント1:" + hints_list[response.formValues[0]])
                break;
            case 1:
                server.world.sendMessage("ヒント2:" + hints_list2[response.formValues[0]])
                break;
            case 2:
                server.world.sendMessage("答え:" + anss_list[response.formValues[0]])
                break;
            default:
                break;
        }
    }).catch(error => {
        return;
    });
}

export const q_list = [
    "（ドロップダウンから知りたいヒントを選択）",
    "1.エメラルドのパスワード入力装置",
    "2.ドリンクバーの謎",
    "3.ラピスラズリのパスワード入力装置",
    "4.「Aa」の謎",
    "5.ダイヤモンドのパスワード入力装置",
    "6.具材の謎",
    "7.アメジストのパスワード入力装置",
    "8.机のハンバーガーの謎",
    "9.ゴールドのパスワード入力装置",
    "10.樹脂のパスワード入力装置",
    "犯人は誰か"
]

export const hints_list = [
    "行き詰まったらヒントを教えるよん",
    "1.§eエメラルドのパスワード入力装置§r:像の台座裏を調べる",
    "2.§eドリンクバーの謎§r:倉庫裏でメモを探す。また、装置は中央上の色と、押したボタンの色が入れ替わる。",
    "3.§eラピスラズリのパスワード入力装置§r:レジ周辺のシフト表を探す",
    "4.§e「Aa」の謎§r:倉庫裏でメモを探す",
    "5.§eダイヤモンドのパスワード入力装置§r:ポテトの値段はそれぞれ、赤はてなブロックやワクドナルド関係者の話からわかる。",
    "6.§e具材の謎§r:倉庫でメモを探す。具材を下から積み上げてハンバーガーを作るみたい。",
    "7.§eアメジストのパスワード入力装置§r:倉庫内で契約書を探す",
    "8.§e机のハンバーガーの謎§r:マインスイーパーの容量で、周囲のハンバーガーの数を示す。",
    "9.§eゴールドのパスワード入力装置§r:客席B（奥側）でブログを探そう。",
    "10.§e樹脂のパスワード入力装置§r:示された三人の名前はなんだろう",
    "§e犯人は誰か§r:「とあるメモ」から始まる２つが怪しい。"
]

export const hints_list2 = [
    "行き詰まったらヒントを教えるよん",
    "1.§eエメラルドのパスワード入力装置§r:ハーランドの話を聞いたあと、店長に話を聞く",
    "2.§eドリンクバーの謎§r:ドリンクの絵画がヒントだ。３ヶ所みにくい場所に隠れているぞ。",
    "3.§eラピスラズリのパスワード入力装置§r:モリスの話を聞いたあと、クルーに話を聞く",
    "4.§e「Aa」の謎§r:奥の倉庫の中を、柵側からのぞいてみよう",
    "5.§eダイヤモンドのパスワード入力装置§r:客席の中のポテトの数をサイズごとに数える",
    "6.§e具材の謎§r:どこかの壁にテラコッタのデザイン",
    "7.§eアメジストのパスワード入力装置§r:ローサンに話を聞く",
    "8.§e机のハンバーガーの謎§r:ど真ん中は食べない。角の３の周りは3つとも食べない",
    "9.§eゴールドのパスワード入力装置§r:パークスに話を聞く",
    "10.§e樹脂のパスワード入力装置§r:連れてきた容疑者の名前の文字数に着目",
    "§e犯人は誰か§r:ずばりお金に困っているのは誰か。それとモブの一人称"
]

export const anss_list = [
    "行き詰まったら答えを教えるよん",
    "1.§aエメラルドのパスワード入力装置§r:「ハンバーガー」",
    "2.§aドリンクバーの謎§r:３ヶ所（道の右奥、コンビニの上、ワクドナルドの道側の壁）のコンクリートに色を合わせる。上段が「緑、黄、紫」下段が「ピンク、黄緑、水」",
    "3.§aラピスラズリのパスワード入力装置§r:「エミリー」",
    "4.§a「Aa」の謎§r:「WcDonaLDs」アルファベットの大きさ順。「AaAaaaAAa」の順に押す",
    "5.§aダイヤモンドのパスワード入力装置§r:「2730」部屋の中のポテトはS150円が4個、M210円が6個、L290円が3個",
    "6.§a具材の謎§r:「バンズ下、チーズ、レタス、トマト、パティ、バンズ上」の順で作る。客席の壁のがら",
    "7.§aアメジストのパスワード入力装置§r:「ゼンブイレブン」",
    "8.§a机のハンバーガーの謎§r:配布サイトに答え貼っときます",
    "9.§aゴールドのパスワード入力装置§r:「タベナビ」",
    "10.§a樹脂のパスワード入力装置§r:「ランランルー」",
    "§a犯人は誰か§r:店長「ガブリ」"
]


// ********************************* //
//ログ
// ********************************* //
const log_on = true;
function log(log_text) {
    if (log_on) server.world.sendMessage("log: " + String(log_text));
}