import * as server from "@minecraft/server";
import * as ui from "@minecraft/server-ui";


export function survey_ModalForm(player) {
}

export function pass_ModalForm(player, block) {
    const x_y_z = String(block.location.x) + " " + String(block.location.y) + " " + String(block.location.z);
    const form = new ui.ModalFormData();
    form.title("パスロック");
    form.textField("認証キーを入力してください", "-");
    form.submitButton("決定");
    form.show(player).then(response => {
        if (response.canceled) {
            return;
        }
        switch (String(response.formValues[0] + "&" + x_y_z)) {
            case "ハンバーガー&30 3 42":
                player.playSound("random.levelup");
                player.runCommandAsync("fill 29 0 40 29 0 41 redstone_torch");
                player.onScreenDisplay.setActionBar("入り口の扉のロックを解除した");
                break;
            case "エミリー&28 3 33":
                player.playSound("random.levelup");
                player.runCommandAsync("fill 26 0 32 27 0 32 redstone_torch");
                player.onScreenDisplay.setActionBar("客席Aの扉のロックを解除した");
                break;
            case "ゼンブイレブン&30 3 28":
                player.playSound("random.levelup");
                player.runCommandAsync("fill 31 0 26 31 0 27 redstone_torch");
                player.onScreenDisplay.setActionBar("客席Bの扉のロックを解除した");
                break;
            case "2730&18 3 33":
                //150* 4 + 210*6 + 290*3 2730
                player.playSound("random.levelup");
                player.runCommandAsync("fill 17 0 34 17 0 35 redstone_torch");
                player.onScreenDisplay.setActionBar("キッチンの扉のロックを解除した");
                break;
            case "タベナビ&2 3 33":
                player.playSound("random.levelup");
                player.runCommandAsync("fill 3 0 32 4 0 32 redstone_torch");
                player.onScreenDisplay.setActionBar("スタッフルームの扉のロックを解除した");
                break;
            case "ランランルー&9 3 18":
                player.playSound("random.levelup");
                player.runCommandAsync("fill 11 0 19 11 0 20 redstone_torch");
                player.onScreenDisplay.setActionBar("裏口の扉のロックを解除した");
                break;
            default:
                player.playSound("note.bass");
                break;
        }
    }).catch(error => {
        return;
    });
}

// ******************************
export function burger(player, block) {
    player.playSound("random.eat");
    switch (block.type.id) {
        case "block:burger":
            block.dimension.setBlockType(block.location, "minecraft:air");
            player.runCommandAsync("function burger/burger");
            break;
        case "block:burger2":
            block.dimension.setBlockType(block.location, "minecraft:air");
            break;
        case "block:burger3":
            player.runCommandAsync("setblock 2 3 39 block:q2");
            player.runCommandAsync("particle c:firework_white 19 3 41");
            break;
        default:
            break;
    }
}
export function drink(player, block) {
    const drink_xyz = "19 " + block.location.y + " " + block.location.z;
    const drink_xyz_ = "19 " + (block.location.y - 10) + " " + block.location.z;
    player.runCommandAsync("clone 19 4 40 19 5 42 19 -6 40");
    player.runCommandAsync("clone " + drink_xyz_ + " " + drink_xyz_ + " 19 5 41");
    player.runCommandAsync("clone 19 -5 41 19 -5 41 " + drink_xyz);
    player.playSound("random.potion.brewed");
    player.runCommandAsync("function drink/drink");
}

let food_orders = 0
const food_orders_true = 143256
export function food(player, block) {
    food_orders *= 10;
    food_orders %= 1000000;
    switch (block.type.id) {
        case "block:food_1":
            food_orders += 1;
            break;
        case "block:food_2":
            food_orders += 2;
            break;
        case "block:food_3":
            food_orders += 3;
            break;
        case "block:food_4":
            food_orders += 4;
            break;
        case "block:food_5":
            food_orders += 5;
            break;
        case "block:food_6":
            food_orders += 6;
            break;
        default:
            break;
    }
    const x_y_z = String(block.location.x) + " " + String(block.location.y + 0.5) + " " + String(block.location.z);
    player.runCommandAsync("particle c:firework_2 " + x_y_z);
    player.playSound("random.orb");
    const food_clicked = food_orders % 10;
    if (food_orders == food_orders_true) {
        player.playSound("random.levelup");
        player.runCommandAsync("setblock 2 3 39 block:burger3");
        player.onScreenDisplay.setActionBar("ハンバーガーができた");
    } else if (food_clicked == 6) {
        player.playSound("note.bass");
        player.runCommandAsync("setblock 2 3 39 block:burger2 keep");
        player.onScreenDisplay.setActionBar("ゴミバーガーができた");
    }
}

export function potato(player, block) {

}

let alb_orders = 0
const alb_orders_true = 212111221
export function alb(player, block) {
    alb_orders *= 10;
    alb_orders %= 1000000000;
    switch (block.type.id) {
        case "block:alb_small":
            alb_orders += 1;
            break;
        case "block:alb_large":
            alb_orders += 2;
            break;
        default:
            break;
    }
    const x_y_z = String(block.location.x) + " " + String(block.location.y + 0.5) + " " + String(block.location.z);
    player.runCommandAsync("particle c:firework_2 " + x_y_z);
    player.playSound("random.orb");
    if (alb_orders == alb_orders_true) {
        player.playSound("random.levelup");
        player.runCommandAsync("fill 5 2 50 11 5 50 air");
        player.onScreenDisplay.setActionBar("倉庫のシャッターが開いた");
    }

}