import * as server from "@minecraft/server";
// アイテムの使用 itemUse
server.world.afterEvents.itemUse.subscribe(event => {
    let player = event.source;
    let item = event.itemStack;
    switch (item.typeId) {
        case "item:camera":
            player.runCommandAsync("function sneak/camera");
            break;
        case "item:camera_stand":
            player.runCommandAsync("function sneak/camera_stand");
            break;
    }
});

//interact検知
server.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    initEvent.blockComponentRegistry.registerCustomComponent("search:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            const xyz = String(block.location.x) + " " + String(block.location.y) + " " + String(block.location.z);
            switch (xyz) {
                case "50 184 58":
                    player.runCommandAsync("function memo/0");
                    break;
                case "30 154 54":
                    player.runCommandAsync("function memo/1");
                    break;
                case "11 154 45":
                    player.runCommandAsync("function memo/2");
                    break;
                case "34 152 13":
                    player.runCommandAsync("function memo/3");
                    break;
                case "36 167 12":
                    player.runCommandAsync("function memo/4");
                    break;
                case "26 198 29":
                    player.runCommandAsync("function memo/9");
                    break;
                default:
                    break;
            }
        }
    });

    initEvent.blockComponentRegistry.registerCustomComponent("lock_chest:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("title @s actionbar チェストはロックされている");
            player.runCommandAsync("playsound hit.copper @s");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("allay_null:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            const xyz = `${block.x} ${block.y} ${block.z}`
            player.runCommandAsync("execute positioned " + xyz + " run function allay/null");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("light_1:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.runCommandAsync("function light/1");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("light_2:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function light/2");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("light_3:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function light/3");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("light_4:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function light/4");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("light_5:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function light/5");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("pattern_1:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function fire/btn/1");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("pattern_2:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function fire/btn/2");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("pattern_3:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function fire/btn/3");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("pattern_4:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            player.runCommandAsync("function fire/btn/4");
        }
    });
});

// ********************************* //
// system
// ********************************* //
// 1tickループ
// server.system.runInterval(() => {
//スニーク
// for (const player of server.world.getAllPlayers()) {
//     if (player.isSneaking) {
//         player.runCommandAsync("scoreboard players set @s[scores={is_sneak=-99..0}] is_sneak 0");
//         player.runCommandAsync("scoreboard players add @s[scores={is_sneak=0..9}] is_sneak 1");
//     } else {
//         player.runCommandAsync("scoreboard players set @s[scores={is_sneak=0..99}] is_sneak 0");
//         player.runCommandAsync("scoreboard players remove @s[scores={is_sneak=-10..0}] is_sneak 1");
//     }
//     // 移動
//     const velocity = player.getVelocity();
//     const velocity_value = Math.abs(velocity.x) + Math.abs(velocity.z);
//     if (velocity_value > 0.05) {
//         player.runCommandAsync("scoreboard players set @s is_moving 1");
//     } else {
//         player.runCommandAsync("scoreboard players set @s is_moving 0");
//     }
// }
// }, 1)

//初期スポン
server.world.afterEvents.playerSpawn.subscribe(event => {
    const player = event.player;
    // player.runCommandAsync("scoreboard players set @s is_sneak 0");

    //音楽再生
    // player.runCommandAsync("music queue sound.bgm 0.5 0 loop");
    // server.world.queueMusic("sound.bgm", {
    //     fade: 1.0,
    //     loop: true,
    //     volume: 0.5,
    // });
    player.runCommandAsync("function z/in");
    player.inputPermissions.cameraEnabled = true;
    player.inputPermissions.movementEnabled = true;
});
// ********************************* //
//ログ
// ********************************* //
const log_on = false;
function log(log_text) {
    if (log_on) server.world.sendMessage("log: " + String(log_text));
}