// ********************************* //
// import
// ********************************* //
import * as server from "@minecraft/server";

import * as vn from "./action/vanilla.js"
import * as og from "./action/original.js"


// ********************************* //
// event
// ********************************* //

// アイテムの使用 itemUse
server.world.afterEvents.itemUse.subscribe(event => {
    let player = event.source;
    let item = event.itemStack;
    switch (item.typeId) {
        case "c:hintbook":
            break;
        default:
            break;
    }
});

//interact検知（基本ブロック）
server.world.afterEvents.playerInteractWithBlock.subscribe(event => {
    let block = event.block;
    switch (block.typeId) {
        case "minecraft:hopper":
            vn.hopper(event);
            break;
        case "minecraft:stone_button":
            vn.stone_button(event);
            break;
        case "minecraft:polished_blackstone_button":
            vn.blackstone_button(event);
            break;
        case "minecraft:flower_pot":
            vn.flower_pot(event);
            break;
        default:
            // タッチ演出
            break;
    }
});
// let cool_time = 0;
//interact検知（基本ブロック）
server.world.beforeEvents.playerInteractWithBlock.subscribe(event => {
    if (!event.isFirstEvent) return;
    let block = event.block;
    switch (block.typeId) {
        // case "minecraft:white_banner":
        //     vn.white_banner(event);
        //     break;
        case "minecraft:blue_wool":
            vn.wool(event, 1);
            break;
        case "minecraft:light_blue_wool":
            vn.wool(event, 2);
            break;
        case "minecraft:orange_wool":
            vn.wool(event, 3);
            break;
        case "minecraft:magenta_wool":
            vn.wool(event, 4);
            break;
        case "minecraft:red_wool":
            vn.wool(event, 5);
            break;
        case "minecraft:yellow_wool":
            vn.wool(event, 6);
            break;
        // case "block:lock_chest":
        //     og.lock_chest(event);
        //     break;
        // case "block:note":
        //     og.note(event);
        //     break;
        // case "block:note_full":
        //     og.note(event);
        //     break;
        // case "block:memo":
        //     og.memo(event);
        //     break;
        // case "block:book":
        //     og.book(event);
        //     break;
        // case "block:fox":
        //     og.fox(event);
        //     break;
        // case "block:fox_stone":
        //     og.fox_stone(event);
        //     break;
        // case "block:parrot":
        //     og.parrot(event);
        //     break;
        // case "block:mob_1":
        //     og.mob(event);
        //     break;
        default:
            break;
    }
    // }
});


server.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    initEvent.blockComponentRegistry.registerCustomComponent("lock_chest:interact", {
        onPlayerInteract: (e) => {
            og.lock_chest(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("note:interact", {
        onPlayerInteract: (e) => {
            og.note(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("memo:interact", {
        onPlayerInteract: (e) => {
            og.memo(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("book:interact", {
        onPlayerInteract: (e) => {
            og.book(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("fox:interact", {
        onPlayerInteract: (e) => {
            og.fox(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("fox_stone:interact", {
        onPlayerInteract: (e) => {
            og.fox_stone(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("parrot:interact", {
        onPlayerInteract: (e) => {
            og.parrot(e);
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("mob:interact", {
        onPlayerInteract: (e) => {
            og.mob(e);
        }
    });
});

// ********************************* //
// system
// ********************************* //

//ワールド参加
server.world.afterEvents.playerSpawn.subscribe(event => {
    const player = event.player;
    player.inputPermissions.cameraEnabled = true;
    player.inputPermissions.movementEnabled = true;
    player.runCommandAsync("setblock 69 94 41 block:note_full");

});

// ********************************* //
// log
// ********************************* //
const log_on = false;
function log(log_text) {
    if (log_on) server.world.sendMessage("log: " + String(log_text));
}