import * as server from "@minecraft/server";

// ブロック設置（設置するアイテム）itemUseOn
server.world.afterEvents.itemUseOn.subscribe(event => {
    let player = event.source;
    let block = event.block;
    let item = event.itemStack;
    switch (item.typeId) {
        case "c:search":
            player.runCommand("fill ~-1 ~-1 ~-1 ~1 ~1 ~1 air replace light_block");
            break;
        default:
            break;
    }
});

// ブロック
export function place(player, block) {
    const x = block.x;
    const y = block.y;
    const z = block.z;
    const xyz = `${x} ${y} ${z}`
    switch (xyz) {
        case "0 5 0":
            player.runCommand("tp @a " + String(`${xyz}`));
            break;
        default:
            break;
    }
};

server.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    /////////////////
    initEvent.blockComponentRegistry.registerCustomComponent("remove:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;

            const x = block.x;
            const y = block.y;
            const z = block.z;
            let xyz = `${x} ${y} ${z}`;
            let xyz_new = `${x} ${y} ${z}`;

            player.runCommand("give @s " + String(`${block.type.id}`));
            block.dimension.setBlockType(block.location, "minecraft:air");
            // 音
            player.runCommand("execute positioned " + String(`${xyz_new}`) + " run playsound block.grindstone.use @a ~ ~ ~");
            // パーティクル
            player.runCommand("execute positioned " + String(`${xyz_new}`) + " run particle part:push ~ ~ ~");

        }
    });
    /////////////////
    initEvent.blockComponentRegistry.registerCustomComponent("placed:interact", {
        onPlayerInteract: (e) => {
        }
    });
});