import * as server from "@minecraft/server";

//interact検知（オリジナルブロック）
server.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    initEvent.blockComponentRegistry.registerCustomComponent("btn:interact", {
        onPlayerInteract: (e) => {
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("btn_on:interact", {
        onPlayerInteract: (e) => {
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("side_btn:interact", {
        onPlayerInteract: (e) => {
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("side_btn_on:interact", {
        onPlayerInteract: (e) => {
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("void_2:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.onScreenDisplay.setActionBar("全ての黒の床ブロックを紫に");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("void_3:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.onScreenDisplay.setActionBar("全て黄色の床ブロックを空に");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("reset_off:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.onScreenDisplay.setActionBar("盤面リセット装置（今はまだ使えないようだ）");
        }
    });
    initEvent.blockComponentRegistry.registerCustomComponent("reset:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
            player.onScreenDisplay.setActionBar("盤面リセット装置");
            // block.dimension.setBlockType(block.location, "minecraft:air");
            // server.system.runTimeout(() => {
            //     block.dimension.setBlockType(block.location, block.type.id);
            // }, 20);

            const x = block.x;
            const y = block.y;
            const z = block.z;
            let xyz = `${x} ${y} ${z}`;
            // 音
            player.runCommand("execute positioned " + String(`${xyz}`) + " run playsound beacon.activate @a ~ ~ ~");
            // パーティクル
            player.runCommand("execute positioned " + String(`${xyz}`) + " run particle part:wakeup ~ ~ ~");

            // 処理
            switch (xyz) {
                //各
                case "61 12 38":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_1 b matches 0 run function golem_reset/first/1");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_1 b matches 4 run function golem_reset/powder/1");
                    break;
                case "54 16 18":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_2 b matches 0 run function golem_reset/first/2");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_2 b matches 4 run function golem_reset/powder/2");
                    break;
                case "22 16 19":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_3 b matches 0 run function golem_reset/first/3");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_3 b matches 4 run function golem_reset/powder/3");
                    break;
                case "19 15 42":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_4 b matches 0 run function golem_reset/first/4");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_4 b matches 4 run function golem_reset/powder/4");
                    break;
                case "26 16 62":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_5 b matches 0 run function golem_reset/first/5");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_5 b matches 4 run function golem_reset/powder/5");
                    break;
                case "58 16 61":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_6 b matches 0 run function golem_reset/first/6");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_6 b matches 4 run function golem_reset/powder/6");
                    break;
                //中央
                case "56 12 38":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 1..2 run function golem_reset/second/1");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 3 run function golem_reset/third/1");
                    break;
                case "58 16 35":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 1..2 run function golem_reset/second/2");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 3 run function golem_reset/third/2");
                    break;
                case "22 16 45":
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 1..2 run function golem_reset/second/3");
                    player.runCommand("execute unless score reset_cool b matches 1.. if score golem_phase b matches 3 run function golem_reset/third/3");
                    break;
            }
            player.runCommand("function golem_reset/cool");

        }
    });


    initEvent.blockComponentRegistry.registerCustomComponent("ms:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;
        }
    });


    initEvent.blockComponentRegistry.registerCustomComponent("golem_sleep:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;

            const x = block.x;
            const y = block.y;
            const z = block.z;
            let xyz = `${x} ${y} ${z}`;
            // 音
            player.runCommand("execute positioned " + String(`${xyz}`) + " run playsound beacon.power @a ~ ~ ~");
            // パーティクル
            player.runCommand("execute positioned " + String(`${xyz}`) + " run particle part:wakeup ~ ~ ~");

            // 処理
            switch (xyz) {
                // 各
                case "120 11 42":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/0");
                    break;
                case "74 11 42":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/1");
                    break;
                case "58 15 5":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/2");
                    break;
                case "26 15 6":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/3");
                    break;
                case "6 14 38":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/4");
                    break;
                case "22 15 75":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/5");
                    break;
                case "54 15 74":
                    player.runCommand("execute if score golem_phase b matches 0..4 run function golem_sleep/wakeup/6");
                    break;
            }
        }
    });
});