import * as sv from "@minecraft/server";

// ********************************* //
// item
// ********************************* //
sv.world.beforeEvents.worldInitialize.subscribe((initEvent) => {
    initEvent.blockComponentRegistry.registerCustomComponent("num:interact", {
        onPlayerInteract: (e) => {
            const player = e.player;
            const block = e.block;

            let set_block_id;
            switch (block.type.id) {
                case "block:num0":
                    set_block_id = "block:num1"
                    break;
                case "block:num1":
                    set_block_id = "block:num2"
                    break;
                case "block:num2":
                    set_block_id = "block:num3"
                    break;
                case "block:num3":
                    set_block_id = "block:num4"
                    break;
                case "block:num4":
                    set_block_id = "block:num5"
                    break;
                case "block:num5":
                    set_block_id = "block:num6"
                    break;
                case "block:num6":
                    set_block_id = "block:num7"
                    break;
                case "block:num7":
                    set_block_id = "block:num8"
                    break;
                case "block:num8":
                    set_block_id = "block:num9"
                    break;
                case "block:num9":
                    set_block_id = "block:num0"
                    break;
                case "block:b2":
                    set_block_id = "block:b1"
                    break;
                case "block:b1":
                    set_block_id = "block:b2"
                    break;
                default:
                    set_block_id = block.type;
                    break;
            }

            block.dimension.setBlockType(block.location, set_block_id);
            player.runCommandAsync("playsound random.pop @s");

            player.runCommandAsync("function check_num");
            // sv.world.runTimeout(() => {
            //     player.runCommandAsync("function check_num")
            // }, 20);

        }
    });
});


sv.world.afterEvents.playerSpawn.subscribe(ev => {
    if (ev.initialSpawn) {
        sv.system.runTimeout(function () {
            for (const player of sv.world.getAllPlayers()) {
                player.runCommandAsync("music play c.bgm 0.5 0 loop");
            }
        }, 40);
    }
});